#include <iostream>
#include <cmath>
#include <string>
#include <algorithm>
#include <cstring>
#include <cstdio>
#include <fstream>
#include <cassert>
#include <map>
#include <set>
#include <vector>
#include <queue>
#include <stack>
#include <functional>
#include <numeric>
#include <ctime>
#include <cstdlib>
#include <sstream>

using namespace std;

#define f first
#define s second
#define mp make_pair
#define pb push_back
#define pii pair<int, int>
#define pll pair<long long, long long>
#define y1 stupid_y1
#define ll long long
#define vi vector<int>
#define forit(it, s) for(__typeof(s.begin()) it = s.begin(); it != s.end(); it++)
#define all(a) a.begin(), a.end()
#define sqr(x) ((x)*(x))
#define sz(a) (int)a.size()
#define file "a"

const int maxn = (int)1e5+11;
const int inf = int(1e9);
const int mod = inf + 7;
const double eps = 1e-9;
const double pi = acos(-1.0);

struct Point {
	double x, y;

	Point () {}
	Point (double x, double y) : x(x), y(y) {}

	void print() {
		printf("%.9lf %.9lf\n", x, y);
	}

	double dist(Point o) {
		return sqrt(sqr(o.x - x) + sqr(o.y - y));
	}
	
	void normalization() {
		double d = sqrt(sqr(x) + sqr(y));
		if(d < eps) return;
		x /= d;
		y /= d;
	}

	Point const operator +(Point o) {
		return Point(x + o.x, y + o.y);
	}
	Point const operator -(Point o) {
		return Point(x - o.x, y - o.y);
	}
	Point const operator *(double k) {
		return Point(x * k, y * k);
	}
	Point const operator /(double k) {
		return Point(x / k, y / k);
	}
};

struct Line {
	double a, b, c;

	Line () {}
	Line (double a, double b, double c) : a(a), b(b), c(c) {}
	Line (Point p, Point q) {
		a =   q.y - p.y;
		b = -(q.x - p.x);
		c = -a * p.x - b * p.y;
	}

	Point intersection(Line o) {
		double d = b * o.a - a * o.b;
		double x = o.b * c - b * o.c;
		double y = a * o.c - o.a * c;
		x /= d; y /= d;
		return Point(x, y);
	}

	double dist(Point o) {
		return (a * o.x + b * o.y + c) / sqrt(sqr(a) + sqr(b));
	}

	Point symmetric(Point o) {
		double d = dist(o);
		d *= -2.0;
		Point v = Point(a, b);
		v.normalization();
		v = v * d;
		return (v+o);
	}
};

struct Shape {
	Line l;
	Point o;
	int isPoint;

	Shape () {}
	Shape (Line _l) {
		isPoint = 0;
		o = Point(0, 0);
		l = _l;
	}
	Shape (Point _o) {
		isPoint = 1;
		o = _o;
		l = Line(0, 0, 0);
	}

	void print() {
		o.print();
	}

	Shape const operator +(Shape s) {
		int x = isPoint, y = s.isPoint;
		if(x && y) {

			Line new_line = Line(o, s.o);
			return Shape(new_line);

		} else if(x && !y) {

			Point new_point = s.l.symmetric(o);
			return Shape(new_point);

		} else if(!x && y) {

			Point new_point = l.symmetric(s.o);
			return Shape(new_point);

		} else {

			Point new_point = l.intersection(s.l);
			return Shape(new_point);

		}
	}
};

string s;
int nxt[maxn];

int toInt(string s) {
	stringstream in;
	in <<s;
	int res;
	in >>res;
	return res;
}

string substr(int l, int r) {
	string ans = "";
	for(int i = l; i <= r; i++) ans += s[i];
	return ans;
}

Shape parse(int l, int r) {
	//cout << l << " " << r << endl;
	if(s[l] != '(') {
		int i = l;
		while(s[i] != ',') i++;
		string first = substr(l, i);
		string second = substr(i+1, r);
		int x = toInt(first);
		int y = toInt(second);
		//cout << "(" << x << ", " << y << ")\n";
		return Shape(Point(x * 1.0, y * 1.0));
	}
	vector <Shape> v;
	for(int i = l; i <= r; i = nxt[i]+2) {
		v.pb(parse(i+1, nxt[i]-1));
	}
	for(int i = 1; i < sz(v); i++) v[0] = v[0] + v[i];
	return v[0];
}

bool solve() {
	cin >> s;
	if(s == "#") return false;

	memset(nxt, -1, sizeof nxt);

	stack<int> st;
	for(int i = 0; i < sz(s); i++) {
		if(s[i] == '(') {
			st.push(i);
		} else if(s[i] == ')') {
			nxt[st.top()] = i;
			st.pop();
		}
	}

	Shape ans = parse(0, sz(s)-1);

	ans.print();

	return true;
}

int main () {

	#ifdef LOCAL
	freopen(file".in", "r", stdin);
	freopen(file".out", "w", stdout);
	#endif

	while(solve());

	#ifdef LOCAL
	cerr << (double)clock() * 1.0 / CLOCKS_PER_SEC << endl;
	#endif

	return 0;
}


